-- `cloudt3-system`.sys_user_sync definition

CREATE TABLE `sys_user_sync`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint       NOT NULL COMMENT '账户ID',
    `outer_sys_code`     varchar(255) NOT NULL COMMENT '外部系统编码',
    `sync_time`          datetime(6)  DEFAULT NULL COMMENT '同步时间',
    `sync_success`       bit(1)       DEFAULT b'0' COMMENT '是否同步成功',
    `sync_finish_time`   datetime(6)  DEFAULT NULL COMMENT '同步结束时间',
    `fail_reason`        longtext COMMENT '同步失败信息',
    `fail_reason_detail` longtext COMMENT '同步失败的详细信息',
    `receipt`            longtext COMMENT '回执信息',
    `outer_user_id`      varchar(255) DEFAULT NULL COMMENT '外部系统用户ID',
    `outer_user_code`    varchar(255) DEFAULT NULL COMMENT '外部系统用户编码',
    `sync_url`           varchar(255) DEFAULT NULL COMMENT '同步接口地址',
    `sync_data`          longtext COMMENT '同步的数据信息',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_sync_outersys` (`outer_sys_code`),
    KEY `idx_sys_user_sync_user` (`user_id`),
    KEY `idx_sys_user_sync_time` (`sync_time`)
) COMMENT ='账号同步记录';

-- `cloudt3-system`.sys_user_sync_record definition

CREATE TABLE `sys_user_sync_record`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `outer_sys_code`     varchar(255) NOT NULL COMMENT '外部系统编码',
    `user_id`            bigint       DEFAULT NULL COMMENT '账户ID',
    `username`           varchar(255) DEFAULT NULL COMMENT '登录号',
    `last_name`          varchar(255) DEFAULT NULL COMMENT '姓名-姓氏',
    `first_name`         varchar(255) DEFAULT NULL COMMENT '姓名-名字',
    `mobile`             varchar(255) DEFAULT NULL COMMENT '手机号',
    `email`              varchar(255) DEFAULT NULL COMMENT '邮箱',
    `id_card`            varchar(255) DEFAULT NULL COMMENT '身份证号',
    `sync_time`          datetime(6)  DEFAULT NULL COMMENT '同步时间',
    `sync_success`       bit(1)       DEFAULT b'0' COMMENT '是否同步成功',
    `sync_finish_time`   datetime(6)  DEFAULT NULL COMMENT '同步结束时间',
    `fail_reason`        longtext COMMENT '同步失败信息',
    `fail_reason_detail` longtext COMMENT '同步失败的详细信息',
    `receipt`            longtext COMMENT '回执信息',
    `outer_user_id`      varchar(255) DEFAULT NULL COMMENT '外部系统用户ID',
    `outer_user_code`    varchar(255) DEFAULT NULL COMMENT '外部系统用户编码',
    `sync_url`           varchar(255) DEFAULT NULL COMMENT '同步接口地址',
    `sync_data`          longtext COMMENT '同步的数据信息',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_syncrd_outersys` (`outer_sys_code`),
    KEY `idx_sys_user_syncrd_user` (`user_id`),
    KEY `idx_sys_user_syncrd_username` (`username`),
    KEY `idx_sys_user_syncrd_time` (`sync_time`)
) COMMENT ='账号同步记录';